/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: UUnicode.cpp,v 1.2 1999/10/06 06:41:01 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CArray.h"
#include "CString.h"
#include "UUnicode.h"

_USING_PGP

// Class CUUnicode member functions

PGPInt32 
UUnicode::UniToAscii(const WCHAR *inUni, CString& outAscii)
{
	PGPUInt32	bufSize	= WideCharToMultiByte(CP_ACP, 0, inUni, -1, NULL, 0, 
		NULL, NULL);

	PGPUInt32	result	= WideCharToMultiByte(CP_ACP, 0, inUni, -1, 
		outAscii.GetBuffer(bufSize), bufSize, NULL, NULL);
	outAscii.ReleaseBuffer();

	if (result == 0)
		THROW_ERRORS(kPGPError_StringOpFailed, GetLastError());

	return result;
}

PGPInt32 
UUnicode::AsciiToUni(const char *inAscii, CArray<WCHAR>& outUni)
{
	PGPUInt32	bufSize	= MultiByteToWideChar(CP_ACP, 0, inAscii, -1, 0, 0);
	outUni.Resize(bufSize);

	PGPUInt32	result	= MultiByteToWideChar(CP_ACP, 0, inAscii, -1, 
		outUni.Get(), bufSize);

	if (result == 0)
		THROW_ERRORS(kPGPError_StringOpFailed, GetLastError());

	return result;
}
